/*==============================================================================
* This do file brings in the UK 1971 Small Area Statistics 
* Data downloaded from Casweb 
* http://cdu.mimas.ac.uk/1971/index.htm
*=============================================================================*/
set more off
clear

cd "$insheet_files/UK"

import excel using "crosswalk_wards.xls", sheet("1971") /// 
	cellrange(A1:B17651) first clear

rename label zonecode
rename nuts_id nuts 

duplicates drop zonecode, force

sort zonecode
save nuts_local_crosswalk_1971.dta, replace

clear
! uncompress "$scratch/UK_census_1971/1971_1_10.csv.Z"
insheet using "$scratch/UK_census_1971/1971_1_10.csv"

replace zonecode = substr(zonecode,1,9)
collapse (sum) c*, by(zonecode)

! compress "$scratch/UK_census_1971/1971_1_10.csv"

tempfile UK_1971_1_10
save `UK_1971_1_10.dta'

clear
! uncompress "$scratch/UK_census_1971/1971_11_21.csv.Z"
insheet using "$scratch/UK_census_1971/1971_11_21.csv"

replace zonecode = substr(zonecode,1,9)
collapse (sum) c*, by(zonecode)

! compress "$scratch/UK_census_1971/1971_11_21.csv"

tempfile UK_1971_11_21
save `UK_1971_11_21.dta'

clear
! uncompress "$scratch/UK_census_1971/1971_22_26.csv.Z"
insheet using "$scratch/UK_census_1971/1971_22_26.csv"

replace zonecode = substr(zonecode,1,9)
collapse (sum) c*, by(zonecode)

! compress "$scratch/UK_census_1971/1971_22_26.csv"

tempfile UK_1971_22_26
save `UK_1971_22_26.dta'

merge 1:1 zonecode using `UK_1971_1_10.dta', assert(3) nogen
merge 1:1 zonecode using `UK_1971_11_21.dta', assert(3) nogen

merge 1:1 zonecode using nuts_local_crosswalk_1971.dta

* IV. Generate Nuts 1 & 2 codes from the NUTS 3 codes  

local sum_var c71*

collapse (sum) `sum_var', by(nuts) 

gen nuts_level=3 

tempfile nuts3
save `nuts3.dta'

gen nuts2=substr(nuts,1,4)
	
collapse (sum) `sum_var', by(nuts2) 
	
rename nuts2 nuts
gen nuts_level=2
	
tempfile nuts2
save `nuts2.dta'
	
clear
use `nuts3.dta'
	
gen nuts1=substr(nuts,1,3)

collapse (sum) `sum_var', by(nuts1) 
	
rename nuts1 nuts
gen nuts_level=1

tempfile nuts1
save `nuts1.dta'
	
gen country=substr(nuts,1,2)

collapse (sum) `sum_var', by(country) 
	
rename country nuts
gen nuts_level=0
	
append using `nuts1.dta'	
append using `nuts2.dta'
append using `nuts3.dta'

*******************************************************************************/

*Population
rename c71s01_032 POP

rename c71s07_269 MEN_0_14_SINGLE
rename c71s07_270 MEN_5_19_SINGLE
rename c71s07_271 MEN_20_24_SINGLE
rename c71s07_272 MEN_25_29_SINGLE
rename c71s07_273 MEN_30_34_SINGLE
rename c71s07_274 MEN_35_39_SINGLE
rename c71s07_275 MEN_40_44_SINGLE
rename c71s07_276 MEN_45_49_SINGLE
rename c71s07_277 MEN_50_54_SINGLE
rename c71s07_278 MEN_55_59_SINGLE
rename c71s07_279 MEN_60_64_SINGLE
rename c71s07_280 MEN_65_69_SINGLE
rename c71s07_281 MEN_70_74_SINGLE
rename c71s07_282 MEN_75_plus_SINGLE

rename c71s07_284 MEN_15_19_MARRIED
rename c71s07_285 MEN_20_24_MARRIED
rename c71s07_286 MEN_25_29_MARRIED
rename c71s07_287 MEN_30_34_MARRIED
rename c71s07_288 MEN_35_39_MARRIED
rename c71s07_289 MEN_40_44_MARRIED
rename c71s07_290 MEN_45_49_MARRIED
rename c71s07_291 MEN_50_54_MARRIED
rename c71s07_292 MEN_55_59_MARRIED
rename c71s07_293 MEN_60_64_MARRIED
rename c71s07_294 MEN_65_69_MARRIED
rename c71s07_295 MEN_70_74_MARRIED
rename c71s07_296 MEN_75_plus_MARRIED

rename c71s07_297 WOMEN_0_14_SINGLE
rename c71s07_298 WOMEN_15_19_SINGLE
rename c71s07_299 WOMEN_20_24_SINGLE
rename c71s07_300 WOMEN_25_29_SINGLE
rename c71s07_301 WOMEN_30_34_SINGLE
rename c71s07_302 WOMEN_35_39_SINGLE
rename c71s07_303 WOMEN_40_44_SINGLE
rename c71s07_304 WOMEN_45_49_SINGLE
rename c71s07_305 WOMEN_50_54_SINGLE
rename c71s07_306 WOMEN_55_59_SINGLE
rename c71s07_307 WOMEN_60_64_SINGLE
rename c71s07_308 WOMEN_65_69_SINGLE
rename c71s07_309 WOMEN_70_74_SINGLE
rename c71s07_310 WOMEN_75_plus_SINGLE

rename c71s07_312 WOMEN_15_19_MARRIED
rename c71s07_313 WOMEN_20_24_MARRIED
rename c71s07_314 WOMEN_25_29_MARRIED
rename c71s07_315 WOMEN_30_34_MARRIED
rename c71s07_316 WOMEN_35_39_MARRIED
rename c71s07_317 WOMEN_40_44_MARRIED
rename c71s07_318 WOMEN_45_49_MARRIED
rename c71s07_319 WOMEN_50_54_MARRIED
rename c71s07_320 WOMEN_55_59_MARRIED
rename c71s07_321 WOMEN_60_64_MARRIED
rename c71s07_322 WOMEN_65_69_MARRIED
rename c71s07_323 WOMEN_70_74_MARRIED
rename c71s07_324 WOMEN_75_plus_MARRIED

rename c71s04_212 MEN_0_4
rename c71s04_213 MEN_5_9
rename c71s04_214 MEN_10_14

rename c71s04_215 WOMEN_0_4
rename c71s04_216 WOMEN_5_9
rename c71s04_217 WOMEN_10_14

egen age_0_4 = rsum(MEN_0_4* WOMEN_0_4*)
egen age_5_9 = rsum(MEN_5_9* WOMEN_5_9*)
egen age_10_14 = rsum(MEN_10_14* WOMEN_10_14*)
egen age_15_19 = rsum(MEN_15_19* WOMEN_15_19*)
egen age_20_24 = rsum(MEN_20_24* WOMEN_20_24*)
egen age_25_29 = rsum(MEN_25_29* WOMEN_25_29*)
egen age_30_34 = rsum(MEN_30_34* WOMEN_30_34*)
egen age_35_39 = rsum(MEN_35_39* WOMEN_35_39*)
egen age_40_44 = rsum(MEN_40_44* WOMEN_40_44*)
egen age_45_49= rsum(MEN_45_49* WOMEN_45_49*)
egen age_50_54 = rsum(MEN_50_54* WOMEN_50_54*)
egen age_55_59 = rsum(MEN_55_59* WOMEN_55_59*)
egen age_60_64 = rsum(MEN_60_64* WOMEN_60_64*)
egen age_65_69 = rsum(MEN_65_69* WOMEN_65_69*)
egen age_70_plus = rsum(MEN_70_74* WOMEN_70_74* MEN_75_plus* WOMEN_75_plus*)

egen age_total = rsum(age*)
drop POP
egen POP = rsum(c71s07_325 c71s07_326 c71s07_327 c71s07_328)

*Economically Active
rename c71s05_218 EA_males_15_19
rename c71s05_219 EA_males_20_24
rename c71s05_220 EA_males_25_29
rename c71s05_221 EA_males_30_34
rename c71s05_222 EA_males_35_39
rename c71s05_223 EA_males_40_44
rename c71s05_224 EA_males_45_49
rename c71s05_225 EA_males_50_54
rename c71s05_226 EA_males_55_59
rename c71s05_227 EA_males_60_64
rename c71s05_228 EA_males_65_69
rename c71s05_229 EA_males_70_74
rename c71s05_230 EA_males_75_plus

rename c71s05_257 EA_males
rename c71s05_260 EMP_males
rename c71s05_261 UNEMP_males
rename c71s05_262 sick_males //note Economically active includes temporarily sick. Remove for calculation of labor force.

rename c71s05_231 EA_females_single_15_19
rename c71s05_232 EA_females_single_20_24
rename c71s05_233 EA_females_single_25_29
rename c71s05_234 EA_females_single_30_34
rename c71s05_235 EA_females_single_35_39
rename c71s05_236 EA_females_single_40_44
rename c71s05_237 EA_females_single_45_49
rename c71s05_238 EA_females_single_50_54
rename c71s05_239 EA_females_single_55_59
rename c71s05_240 EA_females_single_60_64
rename c71s05_241 EA_females_single_65_69
rename c71s05_242 EA_females_single_70_74
rename c71s05_243 EA_females_single_plus

rename c71s05_258 EA_females
rename c71s05_263 EMP_females_single
rename c71s05_264 UNEMP_females_single
rename c71s05_265 sick_females_single

rename c71s05_244 EA_females_married_15_19
rename c71s05_245 EA_females_married_20_24
rename c71s05_246 EA_females_married_25_29
rename c71s05_247 EA_females_married_30_34
rename c71s05_248 EA_females_married_35_39
rename c71s05_249 EA_females_married_40_44
rename c71s05_250 EA_females_married_45_49
rename c71s05_251 EA_females_married_50_54
rename c71s05_252 EA_females_married_55_59
rename c71s05_253 EA_females_married_60_64
rename c71s05_254 EA_females_married_65_69
rename c71s05_255 EA_females_married_70_74
rename c71s05_256 EA_females_married_plus

rename c71s05_259 EA_females_married
rename c71s05_266 EMP_females_married
rename c71s05_267 UNEMP_females_married
rename c71s05_268 sick_females_married

rename c71s28_191 ind_agr_1213
rename c71s28_198 ind_agr_34
rename c71s28_205 ind_agr_5
rename c71s28_212 ind_agr_6
rename c71s28_219 ind_agr_89
rename c71s28_226 ind_agr_71015
rename c71s28_233 ind_agr_11
rename c71s28_240 ind_agr_1214
rename c71s28_247 ind_agr_1617
rename c71s28_254 ind_agr_in_LAA
rename c71s28_261 ind_agr_out_LAA
rename c71s28_268 ind_agr_self

rename c71s28_192 ind_mining_1213
rename c71s28_199 ind_mining_34
rename c71s28_206 ind_mining_5
rename c71s28_213 ind_mining_6
rename c71s28_220 ind_mining_89
rename c71s28_227 ind_mining_71015
rename c71s28_234 ind_mining_11
rename c71s28_241 ind_mining_1214
rename c71s28_248 ind_mining_1617
rename c71s28_255 ind_mining_in_LAA
rename c71s28_262 ind_mining_out_LAA
rename c71s28_269 ind_mining_self

rename c71s28_193 ind_mnfg_1213
rename c71s28_200 ind_mnfg_34
rename c71s28_207 ind_mnfg_5
rename c71s28_214 ind_mnfg_6
rename c71s28_221 ind_mnfg_89
rename c71s28_228 ind_mnfg_71015
rename c71s28_235 ind_mnfg_11
rename c71s28_242 ind_mnfg_1214
rename c71s28_249 ind_mnfg_1617
rename c71s28_256 ind_mnfg_in_LAA
rename c71s28_263 ind_mnfg_out_LAA
rename c71s28_270 ind_mnfg_self

rename c71s28_194 ind_construction_1213
rename c71s28_201 ind_construction_34
rename c71s28_208 ind_construction_5
rename c71s28_215 ind_construction_6
rename c71s28_222 ind_construction_89
rename c71s28_229 ind_construction_71015
rename c71s28_236 ind_construction_11
rename c71s28_243 ind_construction_1214
rename c71s28_250 ind_construction_1617
rename c71s28_257 ind_construction_in_LAA
rename c71s28_264 ind_construction_out_LAA
rename c71s28_271 ind_construction_self

rename c71s28_195 serv_transport_1213
rename c71s28_202 serv_transport_34
rename c71s28_209 serv_transport_5
rename c71s28_216 serv_transport_6
rename c71s28_223 serv_transport_89
rename c71s28_230 serv_transport_71015
rename c71s28_237 serv_transport_11
rename c71s28_244 serv_transport_1214
rename c71s28_251 serv_transport_1617
rename c71s28_258 serv_transport_in_LAA
rename c71s28_265 serv_transport_out_LAA
rename c71s28_272 serv_transport_self

rename c71s28_196 serv_commerce_1213
rename c71s28_203 serv_commerce_34
rename c71s28_210 serv_commerce_5
rename c71s28_217 serv_commerce_6
rename c71s28_224 serv_commerce_89
rename c71s28_231 serv_commerce_71015
rename c71s28_238 serv_commerce_11
rename c71s28_245 serv_commerce_1214
rename c71s28_252 serv_commerce_1617
rename c71s28_259 serv_commerce_in_LAA
rename c71s28_266 serv_commerce_out_LAA
rename c71s28_273 serv_commerce_self

rename c71s28_197 serv_admin_1213
rename c71s28_204 serv_admin_34
rename c71s28_211 serv_admin_5
rename c71s28_218 serv_admin_6
rename c71s28_225 serv_admin_89
rename c71s28_232 serv_admin_71015
rename c71s28_239 serv_admin_11
rename c71s28_246 serv_admin_1214
rename c71s28_253 serv_admin_1617
rename c71s28_260 serv_admin_in_LAA
rename c71s28_267 serv_admin_out_LAA
rename c71s28_274 serv_admin_self

rename c71s22_088 inmigration_males_single
rename c71s22_089 inmigration_males_married
rename c71s22_090 inmigration_females_single
rename c71s22_091 inmigration_females_married

rename c71s19_120 persons_1
rename c71s19_121 persons_2
rename c71s19_122 persons_3
rename c71s19_123 persons_4
rename c71s19_124 persons_5
rename c71s19_125 persons_6
rename c71s19_126 persons_7

rename c71s19_247 home_own
rename c71s19_249 home_no_own_council
rename c71s19_251 home_no_own_private_unfurn
rename c71s19_253 home_no_own_private_furn
rename c71s19_255 home_unknown_own

********************************************************************************

egen UNEMP = rsum(UNEMP_males UNEMP_females_single UNEMP_females_married)
egen EMP   = rsum(EMP_males EMP_females_single EMP_females_married)
egen LF    = rsum(UNEMP EMP)

egen EMP_female = rsum(EMP_females_single EMP_females_married)

drop UNEMP_females_single UNEMP_females_married EMP_females_single EMP_females_married

gen EMP_share_female = EMP_female / EMP * 100

egen ind_agro = rsum(ind_agr_in_LAA ind_agr_out_LAA)
egen ind_mining = rsum(ind_mining_in_LAA ind_mining_out_LAA)
egen ind_mnfg = rsum(ind_mnfg_in_LAA ind_mnfg_out_LAA)
egen ind_construction = rsum(ind_construction_in_LAA ind_construction_out_LAA)
egen ind_total = rsum(ind_mining-ind_construction)
egen serv_transport = rsum(serv_transport_in_LAA serv_transport_out_LAA)
egen serv_commerce = rsum(serv_commerce_in_LAA serv_commerce_out_LAA)
egen serv_admin = rsum(serv_admin_in_LAA serv_admin_out_LAA)
egen serv_total = rsum(serv_transport-serv_admin)

*Industry is a 10 % sample, Multiply by 10 
foreach var of varlist ind_* serv_* {
	replace `var' = `var'*10
}	

egen total = rsum(persons*)
foreach var of varlist persons* {
	gen `var'_share = `var' / total
}

forval n = 1/ 7 {
	gen mean_`n' = persons_`n'_share*`n'
}

egen hh_size = rsum (mean*)

egen home_no_own = rsum(home_no_own*)

********************************************************************************
	
gen year = 1971
rename POP POP_census_1971
sort nuts year

drop if nuts==""

tempfile uk_census_1971
save `uk_census_1971.dta'

keep nuts age* EMP_female EMP_share_female hh_size home_own home_no_own /// 
		home_unknown_own ind_agro ind_mining ind_mnfg ind_construction /// 
		ind_total serv_transport serv_commerce serv_admin serv_total

save "$dta_files/IC_UK_CENS1971.dta", replace

use `uk_census_1971.dta', clear

keep nuts year POP LF EMP UNEMP 

*Report data in thousands
foreach var of varlist POP* LF* EMP* UNEMP* {
	replace `var'=`var'/1000
}

rename POP_cens POP_uk_census_1971 
rename EMP EMP_uk_census_1971
rename UNEMP UNEMP_uk_census_1971
rename LF LF_uk_census_1971 

save "$dta_files/UK_CENS1971_labor.dta", replace

rm nuts_local_crosswalk_1971.dta

